<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Leaflet CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="" />


    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            width: 280px;
            padding: 1.5rem;
            background-color: #212529;
            color: #fff;
            transition: all 0.3s;
            z-index: 1030;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            font-weight: 500;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s, color 0.2s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: #343a40;
            color: #fff;
        }

        .sidebar .nav-link i {
            margin-right: 1rem;
            width: 20px;
            text-align: center;
        }

        .sidebar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: #fff;
        }

        .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s;
            padding: 2rem;
        }

        .navbar-custom {
            padding: 1rem 2rem;
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
        }

        .card-custom {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, .08);
        }

        .welcome-card {
            background: linear-gradient(90deg, #004a7c, #005a9c);
            color: white;
        }

        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1020;
        }

        .sidebar-toggler {
            display: none;
        }

        @media (max-width: 991.98px) {
            .sidebar {
                left: -280px;
            }

            .sidebar.show {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .sidebar.show~.sidebar-overlay {
                display: block;
            }

            .sidebar-toggler {
                display: block;
            }
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .attendance-card {
            width: 100%;

            border: none;
            border-radius: 1rem;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .card-header-custom {
            background: linear-gradient(90deg, #004a7c, #005a9c);
            color: white;
            padding: 1.5rem;
            text-align: center;
        }

        #map {
            height: 250px;
            width: 100%;
        }

        .clock-display {
            font-size: 3rem;
            font-weight: 600;
        }

        .date-display {
            font-size: 1.1rem;
            font-weight: 400;
        }

        .action-buttons .btn {
            padding: 0.75rem;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 0.5rem;
        }

        .status-badge {
            font-size: 1rem;
            padding: 0.6rem 1rem;
        }
    </style>
</head>

<body>

    @include('menu.menuselector')

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
        @include('menu.topbarselector')

        <!-- Page Content -->
        <main class="mt-4">



            <div class="main-container">
                <div class="card attendance-card">
                    <div class="card-header-custom">
                        <h4 class="mb-0 fw-bold">Absensi Karyawan</h4>
                        <p class="mb-0">KSP Bali Surya Mandiri</p>
                    </div>
                    <div class="card-body p-4 text-center">

                        <!-- Clock -->
                        <div class="my-3">
                            <div id="clock" class="clock-display">00:00:00</div>
                            <div id="date" class="date-display">Rabu, 15 Oktober 2025</div>
                        </div>

                        <!-- Map -->
                        <div class="card mb-4" id="map-container">
                            <div id="map"></div>
                        </div>
                        <p class="text-muted small"><i class="bi bi-geo-alt-fill"></i> Lokasi Anda saat ini terdeteksi di sekitar area kantor.</p>

                        <!-- Status -->
                        <div id="attendance-status" class="mb-4">
                            <span class="badge rounded-pill {{ $status['class'] }} status-badge">
                                {{ $status['text'] }}
                            </span>
                        </div>



                        <!-- Buttons -->
                        <div class="d-grid gap-3 action-buttons">
                            <button id="clockInBtn" class="btn btn-success"><i class="bi bi-box-arrow-in-right me-2"></i>Absen Masuk</button>
                            <button id="clockOutBtn" class="btn btn-danger" disabled><i class="bi bi-box-arrow-left me-2"></i>Absen Pulang</button>
                        </div>

                        <!-- Log -->
                        <hr class="my-4">
                        <div id="attendance-status" class="mb-4">
                            <span class="badge rounded-pill {{ $status['class'] }}">
                                {{ $status['text'] }}
                            </span>
                        </div>

                        {{-- LOG MASUK --}}
                        <li id="logMasuk" class="list-group-item d-flex justify-content-between">
                            Absen Masuk:
                            <span class="badge bg-secondary">
                                {{ $absensi->jam_masuk ?? '- - : - -' }}
                            </span>
                        </li>

                        {{-- LOG PULANG --}}
                        <li id="logPulang" class="list-group-item d-flex justify-content-between">
                            Absen Pulang:
                            <span class="badge bg-secondary">
                                {{ $absensi->jam_keluar ?? '- - : - -' }}
                            </span>
                        </li>

                        </ul>
                    </div>

                    <p id="koordinatText" class="text-primary small"></p>
                    <form id="absenForm" action="{{ route('absenkaryawan.store') }}" method="POST">
                        @csrf
                        <input type="hidden" id="jenis" name="jenis">
                        <input type="hidden" id="jam" name="jam">
                        <input type="hidden" id="tanggal" name="tanggal">
                        <input type="hidden" id="status" name="status">
                        <input type="hidden" id="latitude" name="latitude">
                        <input type="hidden" id="longitude" name="longitude">
                    </form>



                </div>
                
            </div>
    </div>



    </main>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Leaflet JS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    {{-- SUCCESS ALERT --}}
    @if(session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session("success") }}',
            showConfirmButton: false,
            timer: 2000
        });
    </script>
    @endif

    {{-- ERROR ALERT --}}
    @if(session('error'))
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ session("error") }}',
            showConfirmButton: true
        });
    </script>
    @endif

    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
    </script>

      

    <script>
        document.addEventListener("DOMContentLoaded", function() {

        // ===============================
            // DEFAULT LOKASI & RADIUS ABSEN
            // ===============================
            const lokasi_kantor = {
                name: "KSP Bali Surya Mandiri",
                address: "Br Penida Kelod, Jehem, Kec. Tembuku, Kabupaten Bangli, Bali 80671",
                lat: {{ $lokasi->latitude ?? -8.670458 }},
                lng: {{ $lokasi->longitude ?? 115.227125 }},
            };

            const radius_absen = {{ $lokasi->radius ?? 100 }}; // meter (ubah sesuai kebutuhan)

        // ===== TAMBAHAN JAM KERJA =====
        const JAM_MASUK = "08:00";
        const JAM_PULANG = "14:00";

        function timeToMinutes(time) {
            const [h, m] = time.split(":").map(Number);
            return h * 60 + m;
        }



            // ==========================================
            // ELEMENT DOM
            // ==========================================
            const clockElement = document.getElementById('clock');
            const dateElement = document.getElementById('date');
            const clockInBtn = document.getElementById('clockInBtn');
            const clockOutBtn = document.getElementById('clockOutBtn');
            const statusElement = document.getElementById('attendance-status');
            const logMasuk = document.querySelector('#logMasuk span');
            const logPulang = document.querySelector('#logPulang span');
            const form = document.getElementById('absenForm');

            // Data dari server
            let jamMasuk = @json($absensi->jam_masuk ?? null);
            let jamPulang = @json($absensi->jam_keluar ?? null);

            // LOGIKA DISABLE BUTTON
            if (!jamMasuk) {
                // Belum absen masuk → masuk aktif, pulang disabled
                clockInBtn.disabled = false;
                clockOutBtn.disabled = true;
            } else if (jamMasuk && !jamPulang) {
                // Sudah absen masuk → masuk disabled, pulang aktif
                clockInBtn.disabled = true;
                clockOutBtn.disabled = false;
            } else if (jamMasuk && jamPulang) {
                // Sudah absen masuk & pulang → keduanya disabled
                clockInBtn.disabled = true;
                clockOutBtn.disabled = true;
            }

            // ==========================================
            // CLOCK
            // ==========================================
            function updateClock() {
                const now = new Date();
                const h = String(now.getHours()).padStart(2, '0');
                const m = String(now.getMinutes()).padStart(2, '0');
                const s = String(now.getSeconds()).padStart(2, '0');

                clockElement.textContent = `${h}:${m}:${s}`;

                const options = {
                    weekday: 'long',
                    year: 'numeric',
                    month: 'long',
                    day: 'numeric'
                };
                dateElement.textContent = now.toLocaleDateString('id-ID', options);
            }
            setInterval(updateClock, 1000);
            updateClock();

            function getCurrentTime() {
                const now = new Date();
                const h = String(now.getHours()).padStart(2, '0');
                const m = String(now.getMinutes()).padStart(2, '0');
                return `${h}:${m}`;
            }

            // ==========================================
            // LEAFLET MAP (Single Init)
            // ==========================================
            const officeLocation = [-8.438636, 115.3784669];
            const map = L.map('map').setView(officeLocation, 15);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '© OpenStreetMap'
            }).addTo(map);

           // L.marker(officeLocation)
            //    .addTo(map)
            //    .bindPopup("<b>Lokasi Kantor</b><br>KSP Bali Surya Mandiri.");
            
            // Radius absensi
            L.circle([lokasi_kantor.lat, lokasi_kantor.lng], {
                radius: radius_absen,
                color: '#198754',
                fillColor: '#198754',
                fillOpacity: 0.25
            }).addTo(map);

            // ==========================================
            // GET CURRENT USER GPS
            // ==========================================
            navigator.geolocation.getCurrentPosition(
        function(position) {
            const lat = position.coords.latitude;
            const lng = position.coords.longitude;

            document.getElementById("latitude").value = lat;
            document.getElementById("longitude").value = lng;

            const userLatLng = L.latLng(lat, lng);
            const officeLatLng = L.latLng(
                lokasi_kantor.lat, 
                lokasi_kantor.lng
            );

            const distance = userLatLng.distanceTo(officeLatLng);

            // Marker user
            L.marker([lat, lng])
                .addTo(map)
                .bindPopup("Lokasi Anda")
                .openPopup();

            map.fitBounds([
                [lat, lng],
                [lokasi_kantor.lat, lokasi_kantor.lng]
            ]);

            // ===============================
            // VALIDASI RADIUS
            // ===============================
            if (distance > radius_absen) {
                Swal.fire({
                    icon: 'error',
                    title: 'Di Luar Area Absensi',
                    html: `
                        Jarak Anda <b>${Math.round(distance)} meter</b><br>
                        Maksimal radius <b>${radius_absen} meter</b>
                    `,
                });

                clockInBtn.disabled = true;
                clockOutBtn.disabled = true;
            }

            document.getElementById("koordinatText").textContent =
                `Jarak ke kantor: ${Math.round(distance)} meter`;
        },
        function(error) {
            Swal.fire({
                icon: 'error',
                title: 'GPS Tidak Aktif',
                text: 'Aktifkan GPS untuk melakukan absensi'
            });
        },
        { enableHighAccuracy: true }
    );

           // ==========================================
            // ABSEN MASUK
            // ==========================================
            clockInBtn.addEventListener("click", function () {

            const time = getCurrentTime();

            let statusAbsen = "hadir";

            // Jika lewat jam 08:00 → TERLAMBAT
            if (time > "08:00") {
                statusAbsen = "terlambat";
            }

            statusElement.innerHTML =
                `<span class="badge rounded-pill ${
                    statusAbsen === 'terlambat'
                        ? 'bg-warning-subtle text-warning-emphasis'
                        : 'bg-success-subtle text-success-emphasis'
                } status-badge">
                    ${statusAbsen === 'terlambat' ? 'Terlambat Hadir' : 'Hadir Tepat Waktu'} @ ${time}
                </span>`;

            logMasuk.textContent = time;
            logMasuk.classList.remove("bg-secondary");
            logMasuk.classList.add("bg-success");

            document.getElementById("jenis").value = "masuk";
            document.getElementById("jam").value = time;
            document.getElementById("tanggal").value = new Date().toISOString().slice(0, 10);
            document.getElementById("status").value = statusAbsen;

            form.submit();

            clockInBtn.disabled = true;
            clockOutBtn.disabled = false;
            });



           // ==========================================
            // ABSEN PULANG
            // ==========================================
            clockOutBtn.addEventListener("click", function() {

            const time = getCurrentTime();

            // TOLAK JIKA < 14:00
            if (timeToMinutes(time) < timeToMinutes(JAM_PULANG)) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Belum Bisa Absen Pulang',
                    text: 'Absen pulang hanya bisa dilakukan setelah jam 14:00',
                });
                return;
            }

            statusElement.innerHTML =
                `<span class="badge rounded-pill bg-primary-subtle text-primary-emphasis status-badge">
                    Absen Pulang @ ${time}
                </span>`;

            logPulang.textContent = time;
            logPulang.classList.remove("bg-secondary");
            logPulang.classList.add("bg-primary");

            document.getElementById("jenis").value = "pulang";
            document.getElementById("jam").value = time;
            document.getElementById("tanggal").value = new Date().toISOString().slice(0, 10);
            document.getElementById("status").value = "pulang";

            form.submit();

            clockOutBtn.disabled = true;
            });

           

        });
    </script>

</body>

</html>