<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Absensi Karyawan - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 260px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .sidebar-footer { position: absolute; bottom: 1rem; width: calc(100% - 3rem); }
        .main-content { margin-left: 260px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .clock-card { background: linear-gradient(90deg, #004a7c, #005a9c); color: white; }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        @media (max-width: 991.98px) {
            .sidebar { left: -260px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
<?php echo $__env->make('menu.menuuser', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbaruser', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <!-- Clock and Attendance Action -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card card-custom clock-card text-center p-4">
                            <h5 id="current-date">Memuat tanggal...</h5>
                            <h1 class="display-4 fw-bold my-2" id="current-time">00:00:00</h1>
                            <p id="attendance-status" class="lead mb-3">Anda belum melakukan absensi hari ini.</p>
                            <div id="location-info" class="text-white-50 small mb-3">
                                <p class="mb-0">Mendeteksi lokasi Anda...</p>
                            </div>
                            <div class="d-grid gap-2 d-sm-flex justify-content-sm-center">
                                <button id="clock-in-btn" class="btn btn-success btn-lg px-4 gap-3">
                                    <i class="bi bi-box-arrow-in-right me-2"></i>Absen Masuk
                                </button>
                                <button id="clock-out-btn" class="btn btn-danger btn-lg px-4" disabled>
                                    <i class="bi bi-box-arrow-left me-2"></i>Absen Pulang
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Data Table -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card card-custom">
                            <div class="card-header bg-white border-0 py-3">
                                <h5 class="mb-0 fw-bold">Log Absensi Terbaru Anda</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle">
                                        <thead>
                                            <tr>
                                                <th scope="col">Tanggal</th>
                                                <th scope="col">Jam Masuk</th>
                                                <th scope="col">Jam Pulang</th>
                                                <th scope="col">Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>12 Okt 2025</td>
                                                <td>08:15</td>
                                                <td>17:02</td>
                                                <td><span class="badge bg-warning-subtle text-warning-emphasis rounded-pill">Terlambat</span></td>
                                            </tr>
                                            <tr>
                                                <td>11 Okt 2025</td>
                                                <td>07:58</td>
                                                <td>17:01</td>
                                                <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Tepat Waktu</span></td>
                                            </tr>
                                             <tr>
                                                <td>10 Okt 2025</td>
                                                <td>-</td>
                                                <td>-</td>
                                                <td><span class="badge bg-info-subtle text-info-emphasis rounded-pill">Izin</span></td>
                                            </tr>
                                            <tr>
                                                <td>09 Okt 2025</td>
                                                <td>07:55</td>
                                                <td>17:00</td>
                                                <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Tepat Waktu</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- GPS Error Modal -->
    <div class="modal fade" id="gpsErrorModal" tabindex="-1" aria-labelledby="gpsErrorModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="gpsErrorModalLabel"><i class="bi bi-exclamation-triangle-fill text-danger me-2"></i>Absensi Gagal</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="gps-error-message">Lokasi Anda terlalu jauh dari kantor untuk melakukan absensi.</p>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // --- SCRIPT UNTUK SIDEBAR RESPONSIVE ---
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }

        // --- SCRIPT UNTUK JAM DIGITAL DAN LOGIKA ABSENSI ---
        document.addEventListener('DOMContentLoaded', function() {
            const timeElement = document.getElementById('current-time');
            const dateElement = document.getElementById('current-date');
            const statusElement = document.getElementById('attendance-status');
            const locationElement = document.getElementById('location-info');
            const clockInBtn = document.getElementById('clock-in-btn');
            const clockOutBtn = document.getElementById('clock-out-btn');
            const gpsErrorModal = new bootstrap.Modal(document.getElementById('gpsErrorModal'));
            const gpsErrorMessage = document.getElementById('gps-error-message');

            // --- PENGATURAN LOKASI KANTOR ---
            const OFFICE_LOCATION = { latitude: -8.6747, longitude: 115.2252 }; // Contoh: Renon, Denpasar
            const MAX_RADIUS_METERS = 50; // Jarak maksimal 50 meter

            // Fungsi untuk menghitung jarak antara dua titik koordinat (Haversine Formula)
            function haversineDistance(coords1, coords2) {
                function toRad(x) { return x * Math.PI / 180; }
                const R = 6371e3; // Radius bumi dalam meter
                const dLat = toRad(coords2.latitude - coords1.latitude);
                const dLon = toRad(coords2.longitude - coords1.longitude);
                const lat1 = toRad(coords1.latitude);
                const lat2 = toRad(coords2.latitude);
                const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.sin(dLon / 2) * Math.sin(dLon / 2) * Math.cos(lat1) * Math.cos(lat2);
                const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
                return R * c;
            }

            function updateClock() {
                const now = new Date();
                const optionsDate = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric', timeZone: 'Asia/Makassar' };
                const optionsTime = { hour: '2-digit', minute: '2-digit', second: '2-digit', hour12: false, timeZone: 'Asia/Makassar' };
                dateElement.textContent = now.toLocaleDateString('id-ID', optionsDate);
                timeElement.textContent = now.toLocaleTimeString('id-ID', optionsTime).replace(/\./g, ':');
            }

            function updateUI(clockInTime, clockOutTime) {
                if (clockInTime && !clockOutTime) {
                    statusElement.innerHTML = `Anda sudah absen masuk pada pukul <strong>${clockInTime}</strong>.`;
                    clockInBtn.disabled = true;
                    clockOutBtn.disabled = false;
                } else if (clockInTime && clockOutTime) {
                    statusElement.innerHTML = `Absensi hari ini selesai. Masuk: <strong>${clockInTime}</strong>, Pulang: <strong>${clockOutTime}</strong>.`;
                    clockInBtn.disabled = true;
                    clockOutBtn.disabled = true;
                } else {
                    statusElement.textContent = 'Anda belum melakukan absensi hari ini.';
                    clockInBtn.disabled = false;
                    clockOutBtn.disabled = true;
                }
            }

            // Fungsi utama untuk menangani proses absensi (Masuk/Pulang)
            function handleAttendance(type) {
                locationElement.innerHTML = `<p class="mb-0"><span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Mencari lokasi Anda...</p>`;
                
                if (!navigator.geolocation) {
                    gpsErrorMessage.textContent = "Browser Anda tidak mendukung Geolocation.";
                    gpsErrorModal.show();
                    locationElement.innerHTML = `<p class="mb-0 text-danger">Geolocation tidak didukung</p>`;
                    return;
                }

                navigator.geolocation.getCurrentPosition(
                    (position) => {
                        const userLocation = {
                            latitude: position.coords.latitude,
                            longitude: position.coords.longitude
                        };
                        const accuracy = position.coords.accuracy;

                        const distance = haversineDistance(OFFICE_LOCATION, userLocation);
                        locationElement.innerHTML = `<p class="mb-0">Jarak dari kantor: ${distance.toFixed(0)} meter. Akurasi: ${accuracy.toFixed(0)} meter.</p>`;

                        if (distance <= MAX_RADIUS_METERS) {
                            // Jika dalam jangkauan, proses absensi
                            const now = new Date();
                            const currentTime = now.toLocaleTimeString('id-ID', { hour: '2-digit', minute: '2-digit', hour12: false, timeZone: 'Asia/Makassar' }).replace(/\./g, ':');
                            
                            if (type === 'in') {
                                clockInData.clockIn = currentTime;
                            } else if (type === 'out') {
                                clockInData.clockOut = currentTime;
                            }
                            localStorage.setItem('clockInData', JSON.stringify(clockInData));
                            updateUI(clockInData.clockIn, clockInData.clockOut);
                        } else {
                            // Jika di luar jangkauan, tampilkan modal error
                            gpsErrorMessage.textContent = `Lokasi Anda terlalu jauh (${distance.toFixed(0)} meter) dari kantor untuk melakukan absensi.`;
                            gpsErrorModal.show();
                        }
                    },
                    (error) => {
                        let message = "Terjadi kesalahan saat mengambil lokasi.";
                        if (error.code === 1) message = "Anda harus mengizinkan akses lokasi untuk absensi.";
                        if (error.code === 2) message = "Lokasi tidak tersedia saat ini.";
                        if (error.code === 3) message = "Gagal mendapatkan lokasi (timeout).";
                        
                        locationElement.innerHTML = `<p class="mb-0 text-warning">${message}</p>`;
                        gpsErrorMessage.textContent = message;
                        gpsErrorModal.show();
                    },
                    { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 }
                );
            }

            let today = new Date().toLocaleDateString('id-ID', { timeZone: 'Asia/Makassar' });
            let clockInData = JSON.parse(localStorage.getItem('clockInData') || '{}');

            if (clockInData.date !== today) {
                clockInData = {};
                localStorage.removeItem('clockInData');
            }
            clockInData.date = today;


            clockInBtn.addEventListener('click', () => handleAttendance('in'));
            clockOutBtn.addEventListener('click', () => handleAttendance('out'));

            setInterval(updateClock, 1000);
            updateClock();
            updateUI(clockInData.clockIn, clockInData.clockOut);
        });
    </script>
</body>
</html>

<?php /**PATH C:\aplikasi-absensi\resources\views/absensikaryawan.blade.php ENDPATH**/ ?>